import 'package:flutter/material.dart';
import 'package:gen_rentals/Services/api_calling.dart';

class RentalProvider extends ChangeNotifier {
  FetchMobileResponse? _response;
  FetchMobileResponse? otpResponse;
  bool _isLoading = false;

  FetchMobileResponse? get response => _response;
  bool get isLoading => _isLoading;
  bool isOtpLoading = false;

  //Fetch registered mobile number
  Future<void> fetchRentalMobile(String mob) async {
    _isLoading = true;
    notifyListeners();

    try {
      final result = await ApiCalling.fetchRentalMobileApi(mob);
      _response = result;
    } catch (e) {
      debugPrint("❌ Provider Error: $e");
      _response = null;
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

  // Fetch OTP for mobile
  Future<void> fetchMobileOtp(String mob, String otp) async {
    isOtpLoading = true;
    notifyListeners();

    try {
      final result = await ApiCalling.fetchMobileOtpApi(mob, otp);
      otpResponse = result;
    } catch (e) {
      debugPrint("❌ OTP API Error: $e");
      otpResponse = null;
    } finally {
      isOtpLoading = false;
      notifyListeners();
    }
  }

}


class FetchMobileResponse {
  String? error;
  String? errorMsg;
  String? accId;
  String? message;

  FetchMobileResponse({this.error, this.errorMsg});

  FetchMobileResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    errorMsg = json['error_msg'];
    accId = json['acc_id'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['error_msg'] = this.errorMsg;
    data['acc_id'] = this.accId;
    data['message'] = this.message;
    return data;
  }
}

